/*
 *  DataTypes.h
 *  Advanced2D
 *
 *  Created by Ralph Smith on 6/20/10.
 *  Copyright 2010 Ralph Smith. All rights reserved.
 *
 */

#ifndef __DATA_TYPES_H__
#define __DATA_TYPES_H__


/* Points. */
struct CGPoint {
	float x;
	float y;
};
typedef struct CGPoint CGPoint;

/* Sizes. */
struct CGSize {
	float width;
	float height;
};
typedef struct CGSize CGSize;

/* Rectangles. */
struct CGRect {
	CGPoint origin;
	CGSize size;
};
typedef struct CGRect CGRect;

inline CGPoint CGPointMake(float x, float y)
{
	CGPoint p; p.x = x; p.y = y; return p;
}

inline CGSize CGSizeMake(float width, float height)
{
	CGSize size; size.width = width; size.height = height; return size;
}

inline CGRect CGRectMake(float x, float y, float width, float height)
{
	CGRect rect;
	rect.origin.x = x; rect.origin.y = y;
	rect.size.width = width; rect.size.height = height;
	return rect;
}

typedef unsigned long NSUInteger;

typedef struct _Quad2f {
	GLfloat bl_x, bl_y;
	GLfloat br_x, br_y;
	GLfloat tl_x, tl_y;
	GLfloat tr_x, tr_y;
} Quad2f;

typedef struct _Color4f {
	GLfloat red;
	GLfloat green;
	GLfloat blue;
	GLfloat alpha;
} Color4f;

inline Color4f ColorNull ()
{
	Color4f color;
	color.red = 1.0;
	color.green = 1.0;
	color.blue = 1.0;
	color.alpha = 1.0;
	return color;
}

inline Color4f Color4fMake(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
	Color4f color; color.red=red; color.green=green; color.blue=blue; color.alpha=alpha;
	return color;
}

// typedef unsigned long DWORD
typedef unsigned long COLOR;
typedef COLOR D3DCOLOR;
#define COLOR_RGBA(r,g,b,a) ((unsigned long)((((a)&0xff)<<24)|(((r)&0xff)<<16)|(((g)&0xff)<<8)|((b)&0xff)))

// maps unsigned 8 bits/channel to D3DCOLOR
#define D3DCOLOR_ARGB(a,r,g,b) ((D3DCOLOR)((((a)&0xff)<<24)|(((r)&0xff)<<16)|(((g)&0xff)<<8)|((b)&0xff)))
#define D3DCOLOR_RGBA(r,g,b,a) D3DCOLOR_ARGB(a,r,g,b)
#define D3DCOLOR_XRGB(r,g,b)   D3DCOLOR_ARGB(0xff,r,g,b)



#endif
