
#include "Timer.h"
	
Timer::Timer(void)
{
	timer_start = timeGetTimeMs();
	reset();
}

Timer::~Timer(void)
{
}

double Timer::timeGetTime()
{
	struct timeval tv;
	gettimeofday (&tv, 0);

	return ((double)tv.tv_sec + (double)tv.tv_usec/1000000);
}

double Timer::timeGetTimeMs()
{
	struct timeval tv;
	gettimeofday (&tv, 0);
	return ((double)tv.tv_sec*1000 + (double)tv.tv_usec/1000);
}

double Timer::getTimer()
{
	return (timeGetTime());
}

double Timer::getStartTimeMillis()
{
	return (timeGetTimeMs() - timer_start);
}


void Timer::sleep(int ms)
{
	double start = getTimer();
	double sleepTime = start + (double)ms/1000;
	while (sleepTime > getTimer());
}

void Timer::reset()
{
	stopwatch_start = getTimer();
}

bool Timer::stopwatch(int ms)
{
	
	if ( timeGetTime() > stopwatch_start + (double)ms/1000 ) {
		stopwatch_start = getTimer();
		return true;
	}
	else return false;
}
