/* Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above notice and this permission notice shall be included in all copies
 * or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
/* File for "Putting It All Together" lesson of the OpenGL tutorial on
 * www.videotutorialsrock.com
 */



#ifndef LOAD_BMP_H_INCLUDED
#define LOAD_BMP_H_INCLUDED

#define LOBYTE(w) ((unsigned char)(w))
#define HIBYTE(w) ((unsigned char)(((unsigned short)(w) >> 8) & 0xFF))
#define RGB565(r, g, b) ((r >> 3) << 11)| ((g >> 2) << 5)| ((b >> 3) << 0)

namespace Advanced2D {
	
	//Represents an image
	class ImageBMP {
		public:
			ImageBMP(char* ps, int w, int h);
			~ImageBMP();
			
			/* An array of the form (R1, G1, B1, R2, G2, B2, ...) indicating the
			 * color of each pixel in image.  Color components range from 0 to 255.
			 * The array starts the bottom-left pixel, then moves right to the end
			 * of the row, then moves up to the next column, and so on.  This is the
			 * format in which OpenGL likes images.
			 */
			char* pixels;
			int width;
			int height;
	};

	//Reads a bitmap image from file.
	ImageBMP* loadBMP(const char* filename);

	void ColorConversion24To16 (unsigned char* lpBits24, int width, int height, unsigned char* lpBits16);

};

#endif
